/****** Object:  StoredProcedure [dbo].[P_GERA_EST_NF_ENT_NFE_PEND]    Script Date: 04/30/2013 17:54:03 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_EST_NF_ENT_NFE_PEND]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GERA_EST_NF_ENT_NFE_PEND]
GO

CREATE PROCEDURE P_GERA_EST_NF_ENT_NFE_PEND 
WITH ENCRYPTION  AS

INSERT INTO EST_NF_ENT_NFE_PEND (CD_EMP, CD_FILIAL, CD_NF)
SELECT DISTINCT
	T.CD_EMP, 
	T.CD_FILIAL, 
	T.CD_NF 
FROM 
	EST_NF_ENT T 
	INNER JOIN EST_NF_SERIE SR_NF ON
	T.CD_EMP = SR_NF.CD_EMP  
	AND T.CD_NF_SERIE	= SR_NF.CD_NF_SERIE 
	AND SR_NF.TP_SR_NFE = 1 

	LEFT JOIN  EST_NF_ENT_NFE  A ON
	T.CD_EMP	= A.CD_EMP AND
	T.CD_FILIAL = A.CD_FILIAL AND
	T.CD_NF		= A.CD_NF

	INNER JOIN EST_NF_ENT_EF_NF_CTR_NF X ON 
	T.CD_EMP	= X.CD_EMP AND
	T.CD_FILIAL = X.CD_FILIAL AND
	T.CD_NF		= X.CD_NF_ENT

	LEFT JOIN EST_NFE_LOTE_ENT L ON 
	T.CD_EMP	= L.CD_EMP AND
	T.CD_FILIAL = L.CD_FILIAL AND
	T.CD_NF		= L.CD_NF 
 WHERE      
	NOT EXISTS (SELECT  CD_EMP 
					FROM  EST_NF_ENT_NFE_PEND PEND
					WHERE 
					T.CD_EMP      = PEND.CD_EMP AND 
					T.CD_FILIAL   = PEND.CD_FILIAL AND 
					T.CD_NF   = PEND.CD_NF)   
	AND T.DT_ENT >= GETDATE()-2
	AND ISNULL(X.FLAG_NOTA_INTEGRACAO,0) <> 1
	AND A.CD_EMP IS NULL 
	AND L.CD_NF IS NULL